/*  ___   ___  ___  _   _  ___   ___   ____ ___  ____  
 * / _ \ /___)/ _ \| | | |/ _ \ / _ \ / ___) _ \|    \ 
 *| |_| |___ | |_| | |_| | |_| | |_| ( (__| |_| | | | |
 * \___/(___/ \___/ \__  |\___/ \___(_)____)___/|_|_|_|
 *                  (____/ 
 * Arduino Smart Car Tutorial Lesson 7
 * Tutorial URL http://osoyoo.com/2019/02/26/osoyoo-v2-robot-car-lesson-7-imitation-driving-with-bluetooth-app/
 * CopyRight www.osoyoo.com

 * After running the code, smart car will go forward 5 seconds, then go backward 5
 * seconds, then left turn for 5 seconds then right turn for 5 seconds then stop. 
 * 
 */
 
#include <SoftwareSerial.h>
SoftwareSerial BLTSerial(4, 5);  //RX,TX
bool deviceConnected = false;
String espBuffer = "";
int buttonState;
 
#define dir1PinRight   12  // Right Motor direction pin 1 to MODEL-X IN1 
#define dir2PinRight  11   // Right Motor direction pin 2 to MODEL-X IN2
#define speedPinRight 9   //RIGHT PWM pin connect MODEL-X ENA
#define speedPinLeft 6    // Left PWM pin connect MODEL-X ENB
#define dir1PinLeft  7    //Left Motor direction pin 1 to MODEL-X IN3 
#define dir2PinLeft  8    //Left Motor direction pin 2 to MODEL-X IN4 
   //back speed
#define HIGH_SPEED 240    //Serial receive buffer

struct car_status{
  int speed;
  int angle;
  int direct;
};

int SPEED =150;  //avoidance motor speed 
int TURNSPEED=50  ;
/*motor control*/
void go_Advance(void)  //Forward
{
  digitalWrite(dir1PinRight, HIGH);
  digitalWrite(dir2PinRight,LOW);
  digitalWrite(dir1PinLeft,HIGH);
  digitalWrite(dir2PinLeft,LOW);

}
void go_Left()  //Turn left
{
  digitalWrite(dir1PinRight, HIGH);
  digitalWrite(dir2PinRight,LOW);
  digitalWrite(dir1PinLeft,LOW);
  digitalWrite(dir2PinLeft,HIGH);
}
void go_Right()  //Turn right
{
  digitalWrite(dir1PinRight, LOW);
  digitalWrite(dir2PinRight,HIGH);
  digitalWrite(dir1PinLeft,HIGH);
  digitalWrite(dir2PinLeft,LOW);
}
void go_Back()  //Reverse
{
  digitalWrite(dir1PinRight, LOW);
  digitalWrite(dir2PinRight,HIGH);
  digitalWrite(dir1PinLeft,LOW);
  digitalWrite(dir2PinLeft,HIGH);
}
void back_Left()  //Reverse
{
  digitalWrite(dir1PinRight, LOW);
  digitalWrite(dir2PinRight,HIGH);
  digitalWrite(dir1PinLeft,HIGH);
  digitalWrite(dir2PinLeft,LOW);
}
void back_Right()  //Reverse
{
  digitalWrite(dir1PinRight, HIGH);
  digitalWrite(dir2PinRight,LOW);
  digitalWrite(dir1PinLeft,LOW);
  digitalWrite(dir2PinLeft,HIGH);
}
void stop_Stop(){
    digitalWrite(dir1PinRight,LOW);
  digitalWrite(dir2PinRight,LOW);
  digitalWrite(dir1PinLeft,LOW);
  digitalWrite(dir2PinLeft,LOW);
   set_Motorspeed(0,0) ;
}

/*set motor speed */
void set_Motorspeed(int speed_L,int speed_R)
{
  analogWrite(speedPinRight,speed_R); 
  analogWrite(speedPinLeft,speed_L);   
}


//WiFi / Bluetooth through the serial control
void do_Uart_Tick()
{
car_status cs;
  // 接收：手机 -> Arduino (处理串口返回的消息)
  if (BLTSerial.available()) {
    char c = BLTSerial.read();
   // Serial.write(c);
    espBuffer += c;

    if (c == '\n') {
      // 检测连接成功消息
      if (espBuffer.indexOf("+BLECONN:") != -1) {
        deviceConnected = true;
        Serial.println("\n[STATUS] Phone Connected!");
      }
      // 检测断开消息并重启广播
      else if (espBuffer.indexOf("+BLEDISCONN:") != -1) {
        deviceConnected = false;
        Serial.println("\n[STATUS] Disconnected! Restarting ADV...");
        delay(500);
        BLTSerial.println("AT+BLEADVSTART"); 
      }
      // 解析手机发来的数据: +WRITE:0,1,3,,8,M,0,10,1
      // 只提取最后4个字段 (M,0,10,1) - 真实的手机数据
      else if (espBuffer.indexOf("+WRITE:") != -1) {
        // 找到前5个逗号的位置，跳过协议字段
        int commaCount = 0;
        int pos = espBuffer.indexOf("+WRITE:");
        if (pos != -1) {
          pos += 7; // 跳过 "+WRITE:" 字符串
          for (int i = pos; i < espBuffer.length(); i++) {
            if (espBuffer.charAt(i) == ',') {
              commaCount++;
              if (commaCount == 5) {
                // 提取第5个逗号之后的所有内容（最后4个字段）
                String phoneData = espBuffer.substring(i + 1);
                phoneData.trim();
                char phoneDataBuffer[50];
                phoneData.toCharArray(phoneDataBuffer, 50);
                cs=get_status(phoneDataBuffer);
                Serial.println("\n[RECV FROM PHONE]: " + phoneData);
                SPEED=cs.speed+50;
                TURNSPEED=SPEED*3/2;
                if (SPEED>250) SPEED=250;
                if (TURNSPEED>250) TURNSPEED=250;
                switch (phoneData[0])    //serial control instructions
                {
                 case 'M':  
                  go_Advance();
                  set_Motorspeed(SPEED,SPEED) ;
                  break;
                  case 'L':
                  if(cs.angle==1) {
                    go_Advance();
                    set_Motorspeed(HIGH_SPEED/2,HIGH_SPEED) ;
                  }
                  if(cs.angle==2) {
                    go_Left();
                    set_Motorspeed(TURNSPEED,HIGH_SPEED) ;
                  }
                  break;
                 case 'R':
                  if(cs.angle==-1) 
                  { go_Advance();
                    set_Motorspeed(HIGH_SPEED,HIGH_SPEED/2) ;
                  }
                  if(cs.angle==-2)  {
                    go_Right();
                    set_Motorspeed(HIGH_SPEED,TURNSPEED) ;
                  }
                  break;
                 case 'B':  
                  go_Back(); 
                  set_Motorspeed(SPEED,SPEED) ;
                  break;
                 case 'X':
                  back_Left();
                  if(cs.angle==1) set_Motorspeed(0,TURNSPEED) ;
                  if(cs.angle==2)
                  set_Motorspeed(TURNSPEED,HIGH_SPEED) ;
                  break;
                 case 'Y':
                  back_Right();
                  if(cs.angle==-1) set_Motorspeed(TURNSPEED,0) ;
                  if(cs.angle==-2) set_Motorspeed(HIGH_SPEED,TURNSPEED) ;
                  break;
                 case 'E': stop_Stop() ;break;
                 case 'J': stop_Stop() ;break;
                 default:break;
               }
                break;
              }
            }
          }
        }
      }
      espBuffer = "";
    }
  }

  // 发送：Arduino -> 手机 (移除 # 识别逻辑)
  if (Serial.available()) {
    String input = Serial.readStringUntil('\n');
    input.trim();
    
    if (input.length() > 0) {
      // 如果输入以 "AT" 开头（忽略大小写），则直接发送指令
      String upperInput = input;
      upperInput.toUpperCase();
      if (upperInput.startsWith("AT")) {
        Serial.println("\n[COMMAND SENT]: " + input);
        BLTSerial.println(input);
      } 
      // 否则，视为普通数据发送给手机
      else {
        sendBleNotify(input);
      }
    }
  }
}

//car motor control
void setup()
{
 
  pinMode(dir1PinRight, OUTPUT); 
  pinMode(dir2PinRight, OUTPUT); 
  pinMode(speedPinRight, OUTPUT);  
  pinMode(dir1PinLeft, OUTPUT);
  pinMode(dir2PinLeft, OUTPUT); 
  pinMode(speedPinLeft, OUTPUT); 
  stop_Stop();
   
  Serial.begin(9600);//In order to fit the Bluetooth module's default baud rate, only 9600
   BLTSerial.begin(9600);
   Serial.println("\n--- BLE Initialization (WiFi Disabled) ---");
  // 核心配置流程
  configureBLE();
}
int lastButtonState=0;
void loop()
{  
  do_Uart_Tick();
 
}

car_status get_status( char buffUART[])
{
  car_status cstatus;
  int index=2;
  if (buffUART[index]=='-'){
    cstatus.angle=-buffUART[index+1]+'0';
    index=index+3;
    
  } else {
   
    cstatus.angle=buffUART[index]-'0';
     index=index+2;
  }
  int currentvalue;
  int spd=0;
  while (buffUART[index]!=',')
  {
    currentvalue=buffUART[index]-'0';
    spd=spd*10+currentvalue;
    index++;
  }
  cstatus.speed=spd;
  index++;
  cstatus.direct=buffUART[index]-'0';
  return cstatus;
}
void configureBLE() {
  Serial.println("--- Executing Hard Reset & WiFi Disable ---");
  
  // 1. 恢复出厂设置
  //sendATCommand("AT+RESTORE", 3000); 
  
  // 2. 重新同步波特率为 9600 提高软串口稳定性
  BLTSerial.end();
  BLTSerial.begin(115200);
  sendATCommand("AT+UART_CUR=9600,8,1,0,0", 1000);
  BLTSerial.end();
  BLTSerial.begin(9600);

  // 3. 彻底关闭 WiFi 功能 (模式 0 代表 Null Mode)
  sendATCommand("AT+CWMODE=0", 1000); 

  // 4. 初始化 BLE 模块 (2: Server 模式)
  sendATCommand("AT+BLEINIT=2", 2000);
  
  // 设置蓝牙广播名称
  sendATCommand("AT+BLENAME=\"OSOYOO_BLE\"", 1000);
  
  // 5. 开启 GATT 服务 (必须执行)
  sendATCommand("AT+BLEGATTSSRVCRE", 2000);
  sendATCommand("AT+BLEGATTSSRVSTART", 1000);
  
  // 6. 设置广播数据并正式启动
  sendATCommand("AT+BLEADVDATA=\"020106070943335f424c45\"", 1000);
  sendATCommand("AT+BLEADVSTART", 1000);
  
  Serial.println("\n--- BLE Setup Finished ---");
  sendATCommand("AT+BLEADDR?", 1000);
  //Serial.println("WiFi Disabled. Search for 'C3_BLE' in nRF Connect.");

  
}

void sendBleNotify(String msg) {
  if (!deviceConnected) {
    Serial.println("\n[FAIL] No device connected via BLE.");
    return;
  }

  // 1. 发送 Notify 指令，使用查询到的 char_index = 6
  BLTSerial.print("AT+BLEGATTSNTFY=0,1,6,");
  BLTSerial.println(msg.length());

  // 2. 这里的延迟是为了等待 ESP32 响应，如果软串口速度较慢建议保持
  delay(100); 
  
  // 3. 发送实际数据
  BLTSerial.print(msg);
  Serial.println("\n[DATA SENT TO PHONE]: " + msg);
}

void sendATCommand(String cmd, int timeout) {
  BLTSerial.println(cmd);
  unsigned long t = millis();
  while (millis() - t < timeout) {
    while (BLTSerial.available()) {
      Serial.write(BLTSerial.read());
    }
  }
}

