/*  ___   ___  ___  _   _  ___   ___   ____ ___  ____
 * / _ \ /___)/ _ \| | | |/ _ \ / _ \ / ___) _ \|    \
 *| |_| |___ | |_| | |_| | |_| | |_| ( (__| |_| | | | |
 * \___/(___/ \___/ \__  |\___/ \___(_)____)___/|_|_|_|
 *                  (____/
 * Arduino Smart Car Tutorial - WiFi HTTP Web Server Control
 * Modified to support WiFi HTTP web control
 * Web interface with arrow buttons for Forward, Backward, Left, Right, Stop
 */

#include <WiFi.h>
#include <WebServer.h>

// WiFi credentials - Change these to your network
const char* ssid = "montcruiser";        // Change to your WiFi name
const char* password = "AB19681216";     // Change to your WiFi password

// HTTP server on port 8888
WebServer server(8888);
#define speedPinR 16    //  RIGHT PWM pin connect L298N ENA
#define RightMotorDirPin1  23    //Right Motor direction pin 1 to L298N IN1 
#define RightMotorDirPin2  25    //Right Motor direction pin 2 to L298N IN2
#define speedPinL 17    // Left PWM pin connect L298N ENB
#define LeftMotorDirPin1  26    //Left Motor direction pin 1 to L298N IN3 
#define LeftMotorDirPin2  27   //Left Motor direction pin 1 to L298N IN4 
#define SPEED 120
#define TURN_SPEED 120
#define TURN_TIME 300

/*motor control*/
void go_Advance(void)  //Make Car Going Forward
{
  digitalWrite(RightMotorDirPin1, HIGH);
  digitalWrite(RightMotorDirPin2,LOW);
  digitalWrite(LeftMotorDirPin1,HIGH);
  digitalWrite(LeftMotorDirPin2,LOW);
  analogWrite(speedPinL,SPEED);
  analogWrite(speedPinR,SPEED);
}
void go_Left(int t=0)  //Make Car Going Turn left
{
  digitalWrite(RightMotorDirPin1, HIGH);
  digitalWrite(RightMotorDirPin2,LOW);
  digitalWrite(LeftMotorDirPin1,LOW);
  digitalWrite(LeftMotorDirPin2,HIGH);
  analogWrite(speedPinL,TURN_SPEED);
  analogWrite(speedPinR,TURN_SPEED);
  delay(t);
  digitalWrite(RightMotorDirPin1, LOW);
  digitalWrite(RightMotorDirPin2,LOW);
  digitalWrite(LeftMotorDirPin1,LOW);
  digitalWrite(LeftMotorDirPin2,LOW);
  analogWrite(speedPinL,LOW);
  analogWrite(speedPinR,LOW);
}
void go_Right(int t=0)  //Make Car Going Turn right
{
  digitalWrite(RightMotorDirPin1, LOW);
  digitalWrite(RightMotorDirPin2,HIGH);
  digitalWrite(LeftMotorDirPin1,HIGH);
  digitalWrite(LeftMotorDirPin2,LOW);
  analogWrite(speedPinL,TURN_SPEED);
  analogWrite(speedPinR,TURN_SPEED);
  delay(t);
  digitalWrite(RightMotorDirPin1, LOW);
  digitalWrite(RightMotorDirPin2,LOW);
  digitalWrite(LeftMotorDirPin1,LOW);
  digitalWrite(LeftMotorDirPin2,LOW);
  analogWrite(speedPinL,LOW);
  analogWrite(speedPinR,LOW);
}
void go_Back(int t=0)  //Make Car Going Going Backward
{
  digitalWrite(RightMotorDirPin1, LOW);
  digitalWrite(RightMotorDirPin2,HIGH);
  digitalWrite(LeftMotorDirPin1,LOW);
  digitalWrite(LeftMotorDirPin2,HIGH);
  analogWrite(speedPinL,SPEED);
  analogWrite(speedPinR,SPEED);
  delay(t);

}
void stop_Stop()    //Stop the Car
{
  digitalWrite(RightMotorDirPin1, LOW);
  digitalWrite(RightMotorDirPin2,LOW);
  digitalWrite(LeftMotorDirPin1,LOW);
  digitalWrite(LeftMotorDirPin2,LOW);
}
/*set motor speed */
void set_Motorspeed(int speed_L,int speed_R)
{
  analogWrite(speedPinL,speed_L); //Set Left Motor Speed 
  analogWrite(speedPinR,speed_R); //Set Right Motor Speed 
}

//Pins initialize
void init_GPIO()
{
	pinMode(RightMotorDirPin1, OUTPUT);
	pinMode(RightMotorDirPin2, OUTPUT);
	pinMode(speedPinL, OUTPUT);

	pinMode(LeftMotorDirPin1, OUTPUT);
  pinMode(LeftMotorDirPin2, OUTPUT);
  pinMode(speedPinR, OUTPUT);
	stop_Stop();
}

// HTML web page with arrow buttons
const char webpage[] PROGMEM = R"=====(
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>ESP32 Robot Car Control</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      text-align: center;
      background-color: #1a1a1a;
      color: white;
      margin: 0;
      padding: 20px;
    }
    h1 {
      color: #4CAF50;
      margin-bottom: 30px;
    }
    .control-panel {
      display: inline-block;
      margin: 20px auto;
    }
    .button-row {
      display: flex;
      justify-content: center;
      margin: 10px 0;
    }
    .control-btn {
      background-color: #4CAF50;
      border: none;
      color: white;
      padding: 20px;
      text-align: center;
      font-size: 24px;
      margin: 5px;
      cursor: pointer;
      border-radius: 10px;
      width: 80px;
      height: 80px;
      transition: all 0.3s;
    }
    .control-btn:active {
      background-color: #45a049;
      transform: scale(0.95);
    }
    .control-btn:hover {
      background-color: #45a049;
      box-shadow: 0 0 20px rgba(76, 175, 80, 0.5);
    }
    .stop-btn {
      background-color: #f44336;
    }
    .stop-btn:hover, .stop-btn:active {
      background-color: #da190b;
      box-shadow: 0 0 20px rgba(244, 67, 54, 0.5);
    }
    .invisible {
      opacity: 0;
      pointer-events: none;
    }
    #status {
      margin-top: 30px;
      font-size: 18px;
      color: #4CAF50;
    }
  </style>
</head>
<body>
  <h1>🚗 OSOYOO ESP32 Robot Car Control</h1>

  <div class="control-panel">
    <div class="button-row">
      <button class="control-btn invisible">⬆</button>
      <button class="control-btn" onclick="sendCommand('/forward')">⬆</button>
      <button class="control-btn invisible">⬆</button>
    </div>
    <div class="button-row">
      <button class="control-btn" onclick="sendCommand('/left')">⬅</button>
      <button class="control-btn stop-btn" onclick="sendCommand('/stop')">⏹</button>
      <button class="control-btn" onclick="sendCommand('/right')">➡</button>
    </div>
    <div class="button-row">
      <button class="control-btn invisible">⬇</button>
      <button class="control-btn" onclick="sendCommand('/backward')">⬇</button>
      <button class="control-btn invisible">⬇</button>
    </div>
  </div>

  <div id="status">Ready</div>

  <script>
    function sendCommand(command) {
      fetch(command)
        .then(response => response.text())
        .then(data => {
          document.getElementById('status').innerText = data;
        })
        .catch(error => {
          document.getElementById('status').innerText = 'Error: ' + error;
        });
    }
  </script>
</body>
</html>
)=====";

// HTTP route handlers
void handleRoot() {
  server.send(200, "text/html", webpage);
}

void handleForward() {
  Serial.println("Command: Forward");
  go_Advance();
  server.send(200, "text/plain", "Moving Forward");
}

void handleBackward() {
  Serial.println("Command: Backward");
  go_Back();
  server.send(200, "text/plain", "Moving Backward");
}

void handleLeft() {
  Serial.println("Command: Turn Left");
  go_Left(TURN_TIME);
  server.send(200, "text/plain", "Turning Left");
}

void handleRight() {
  Serial.println("Command: Turn Right");
  go_Right(TURN_TIME);
  server.send(200, "text/plain", "Turning Right");
}

void handleStop() {
  Serial.println("Command: Stop");
  stop_Stop();
  server.send(200, "text/plain", "Stopped");
}

void handleNotFound() {
  server.send(404, "text/plain", "404: Not Found");
}

void setup()
{
  // Initialize Serial for debugging
  Serial.begin(9600);
  delay(10);

  // Initialize GPIO pins
  init_GPIO();

  // Connect to WiFi
  Serial.println();
  Serial.print("Connecting to WiFi: ");
  Serial.println(ssid);

  WiFi.begin(ssid, password);

  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }

  Serial.println("");
  Serial.println("WiFi connected!");
  Serial.print("IP address: ");
  Serial.println(WiFi.localIP());

  // Configure HTTP server routes
  server.on("/", handleRoot);
  server.on("/forward", handleForward);
  server.on("/backward", handleBackward);
  server.on("/left", handleLeft);
  server.on("/right", handleRight);
  server.on("/stop", handleStop);
  server.onNotFound(handleNotFound);

  // Start HTTP server
  server.begin();
  Serial.println("HTTP server started on port: 8888");
  Serial.print("Access web interface at: http://");
  Serial.print(WiFi.localIP());
  Serial.println(":8888");

  // Stop car initially
  stop_Stop();
}

void loop() {
  // Handle HTTP client requests
  server.handleClient();
}
