/*  ___   ___  ___  _   _  ___   ___   ____ ___  ____
 * / _ \ /___)/ _ \| | | |/ _ \ / _ \ / ___) _ \|    \
 *| |_| |___ | |_| | |_| | |_| | |_| ( (__| |_| | | | |
 * \___/(___/ \___/ \__  |\___/ \___(_)____)___/|_|_|_|
 *                  (____/
 * Arduino Smart Car Tutorial - WiFi UDP Control
 * Modified to support WiFi UDP control
 * Commands: A=Forward, B=Backward, L=Left, R=Right, E=Stop
 */

#include <WiFi.h>
#include <WiFiUdp.h>

// WiFi credentials - Change these to your network
const char* ssid = "montcruiser";        // Change to your WiFi name
const char* password = "AB19681216";     // Change to your WiFi password

// UDP settings
WiFiUDP udp;
const unsigned int localUdpPort = 8888;  // UDP port to listen on
char incomingPacket[255];  // buffer for incoming packets
#define speedPinR 16    //  RIGHT PWM pin connect L298N ENA
#define RightMotorDirPin1  23    //Right Motor direction pin 1 to L298N IN1 
#define RightMotorDirPin2  25    //Right Motor direction pin 2 to L298N IN2
#define speedPinL 17    // Left PWM pin connect L298N ENB
#define LeftMotorDirPin1  26    //Left Motor direction pin 1 to L298N IN3 
#define LeftMotorDirPin2  27   //Left Motor direction pin 1 to L298N IN4 
#define SPEED 120
#define TURN_SPEED 120
#define TURN_TIME 300

/*motor control*/
void go_Advance(void)  //Make Car Going Forward
{
  digitalWrite(RightMotorDirPin1, HIGH);
  digitalWrite(RightMotorDirPin2,LOW);
  digitalWrite(LeftMotorDirPin1,HIGH);
  digitalWrite(LeftMotorDirPin2,LOW);
  analogWrite(speedPinL,SPEED);
  analogWrite(speedPinR,SPEED);
}
void go_Left(int t=0)  //Make Car Going Turn left
{
  digitalWrite(RightMotorDirPin1, HIGH);
  digitalWrite(RightMotorDirPin2,LOW);
  digitalWrite(LeftMotorDirPin1,LOW);
  digitalWrite(LeftMotorDirPin2,HIGH);
  analogWrite(speedPinL,TURN_SPEED);
  analogWrite(speedPinR,TURN_SPEED);
  delay(t);
  digitalWrite(RightMotorDirPin1, LOW);
  digitalWrite(RightMotorDirPin2,LOW);
  digitalWrite(LeftMotorDirPin1,LOW);
  digitalWrite(LeftMotorDirPin2,LOW);
  analogWrite(speedPinL,LOW);
  analogWrite(speedPinR,LOW);
}
void go_Right(int t=0)  //Make Car Going Turn right
{
  digitalWrite(RightMotorDirPin1, LOW);
  digitalWrite(RightMotorDirPin2,HIGH);
  digitalWrite(LeftMotorDirPin1,HIGH);
  digitalWrite(LeftMotorDirPin2,LOW);
  analogWrite(speedPinL,TURN_SPEED);
  analogWrite(speedPinR,TURN_SPEED);
  delay(t);
  digitalWrite(RightMotorDirPin1, LOW);
  digitalWrite(RightMotorDirPin2,LOW);
  digitalWrite(LeftMotorDirPin1,LOW);
  digitalWrite(LeftMotorDirPin2,LOW);
  analogWrite(speedPinL,LOW);
  analogWrite(speedPinR,LOW);
}
void go_Back(int t=0)  //Make Car Going Going Backward
{
  digitalWrite(RightMotorDirPin1, LOW);
  digitalWrite(RightMotorDirPin2,HIGH);
  digitalWrite(LeftMotorDirPin1,LOW);
  digitalWrite(LeftMotorDirPin2,HIGH);
  analogWrite(speedPinL,SPEED);
  analogWrite(speedPinR,SPEED);
  delay(t);

}
void stop_Stop()    //Stop the Car
{
  digitalWrite(RightMotorDirPin1, LOW);
  digitalWrite(RightMotorDirPin2,LOW);
  digitalWrite(LeftMotorDirPin1,LOW);
  digitalWrite(LeftMotorDirPin2,LOW);
}
/*set motor speed */
void set_Motorspeed(int speed_L,int speed_R)
{
  analogWrite(speedPinL,speed_L); //Set Left Motor Speed 
  analogWrite(speedPinR,speed_R); //Set Right Motor Speed 
}

//Pins initialize
void init_GPIO()
{
	pinMode(RightMotorDirPin1, OUTPUT); 
	pinMode(RightMotorDirPin2, OUTPUT); 
	pinMode(speedPinL, OUTPUT);  
 
	pinMode(LeftMotorDirPin1, OUTPUT);
  pinMode(LeftMotorDirPin2, OUTPUT); 
  pinMode(speedPinR, OUTPUT); 
	stop_Stop();
}

void setup()
{
  // Initialize Serial for debugging
  Serial.begin(9600);
  delay(10);

  // Initialize GPIO pins
  init_GPIO();

  // Connect to WiFi
  Serial.println();
  Serial.print("Connecting to WiFi: ");
  Serial.println(ssid);

  WiFi.begin(ssid, password);

  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }

  Serial.println("");
  Serial.println("WiFi connected!");
  Serial.print("IP address: ");
  Serial.println(WiFi.localIP());

  // Start UDP
  udp.begin(localUdpPort);
  Serial.print("UDP server started on port: ");
  Serial.println(localUdpPort);

  // Stop car initially
  stop_Stop();
}

void loop() {
  int packetSize = udp.parsePacket();

  if (packetSize) {
    // Receive incoming UDP packets
    int len = udp.read(incomingPacket, 255);
    if (len > 0) {
      incomingPacket[len] = 0;  // Null-terminate string
    }

    Serial.print("Received UDP packet: ");
    Serial.println(incomingPacket);

    // Process command
    char command = incomingPacket[0];

    switch(command) {
      case 'A':
      case 'a':
        Serial.println("Command: Forward");
        go_Advance();
        break;

      case 'B':
      case 'b':
        Serial.println("Command: Backward");
        go_Back();
        break;

      case 'L':
      case 'l':
        Serial.println("Command: Turn Left");
        go_Left(TURN_TIME);
        break;

      case 'R':
      case 'r':
        Serial.println("Command: Turn Right");
        go_Right(TURN_TIME);
        break;

      case 'E':
      case 'e':
        Serial.println("Command: Stop");
        stop_Stop();
        break;

      default:
        Serial.println("Unknown command");
        break;
    }

    // Send acknowledgment back to sender
    udp.beginPacket(udp.remoteIP(), udp.remotePort());
    udp.printf("Command '%c' received", command);
    udp.endPacket();
  }
}
