/*  ___   ___  ___  _   _  ___   ___   ____ ___  ____  
 * / _ \ /___)/ _ \| | | |/ _ \ / _ \ / ___) _ \|    \ 
 *| |_| |___ | |_| | |_| | |_| | |_| ( (__| |_| | | | |
 * \___/(___/ \___/ \__  |\___/ \___(_)____)___/|_|_|_|
 *                  (____/ 
 *How to use MPU6050 Gyro to make OSOYOO Robot Car Go Straight
 * Tutorial URL https://osoyoo.com/?p=60195
 * CopyRight www.osoyoo.com
 */
#include <MPU6050_light.h>
#include <Wire.h>
#include <PID_v1.h>

// Model X (L298N) H bridge Pin Connections
#define speedPinR 16    // K1/K2 RIGHT PWM   connect MODEL-X ENA
#define RightMotorDirPin1  23    //K1/K2 Right Motor direction pin 1 to MODEL-X IN1 
#define RightMotorDirPin2  25    //K1/K2 Right Motor direction pin 2 to MODEL-X IN2
#define speedPinL 17    // K3/K4 Left PWM pin connect MODEL-X ENB
#define LeftMotorDirPin1  26    //K3/K4 Left Motor direction pin 1 to MODEL-X IN3 
#define LeftMotorDirPin2  27   //K3/K4 Left Motor direction pin 2 to MODEL-X IN4 
#define baseSpeed  200

// --- MPU6050 & PID Instance ---
MPU6050 mpu(Wire);

// PID 
double Direction, Input, Output; // Direction: target angle(0 degree), Input: current value, Output: PID adjust output
double Kp=5, Ki=0, Kd=0;         // PID variable paramters needs to be adjusted

// create a PID distance
// &Input：origintal value
// &Output: PID   output value
// &Direction : Target variable
// Kp, Ki, Kd：PID 
 
PID myPID(&Input, &Output, &Direction, Kp, Ki, Kd, DIRECT);


// --- motor function ---
void move(int speed_L=100,int speed_R=100)  //Forward
{
  speed_L = constrain(speed_L, -255, 255);
  speed_R = constrain(speed_R, -255, 255);
  if(speed_R>=0){  // if speed_R >=0, Right motor move forward
    digitalWrite(RightMotorDirPin1, HIGH);
    digitalWrite(RightMotorDirPin2,LOW);
    analogWrite(speedPinR,speed_R);   
  }else{ // if speed_R <>=>0, Right motor move backward
    digitalWrite(RightMotorDirPin1, LOW);
    digitalWrite(RightMotorDirPin2,HIGH);
    analogWrite(speedPinR,-speed_R); 
  }

  if(speed_L>=0){
    digitalWrite(LeftMotorDirPin1,HIGH);
    digitalWrite(LeftMotorDirPin2,LOW);
    analogWrite(speedPinL,speed_L); 
  } else {
    digitalWrite(LeftMotorDirPin1,LOW);
    digitalWrite(LeftMotorDirPin2,HIGH);
    analogWrite(speedPinL,-speed_L); 
  }
}

void stop_Stop()    //Stop
{
  digitalWrite(RightMotorDirPin1, LOW);
  digitalWrite(RightMotorDirPin2,LOW);
  digitalWrite(LeftMotorDirPin1,LOW);
  digitalWrite(LeftMotorDirPin2,LOW);
}

void init_GPIO()
{
	pinMode(RightMotorDirPin1, OUTPUT); 
	pinMode(RightMotorDirPin2, OUTPUT); 
	pinMode(speedPinL, OUTPUT);  
 
	pinMode(LeftMotorDirPin1, OUTPUT);
  pinMode(LeftMotorDirPin2, OUTPUT); 
  pinMode(speedPinR, OUTPUT); 
	stop_Stop();
}

void setup()
{
  Serial.begin(9600);
	init_GPIO();

  // --- initialize MPU6050 ---
  Wire.begin();
  byte status = mpu.begin();
  Serial.print("MPU6050 status: ");
  Serial.println(status);
  while(status != 0) {
    Serial.println("Failed to find MPU6050 chip");
    delay(1000);
  }
  Serial.println("MPU6050 Found!");

  Serial.println("Calculating offsets, do not move MPU6050");
  delay(1000);
  mpu.calcOffsets(); // Calibrate gyro and accelerometer
  Serial.println("Done!\n");

  // --- initialize PID ---
  Direction = 0; // target is to keep 0 degree direction , you can update this value to change moving direction.
  myPID.SetMode(AUTOMATIC); // start PID
  myPID.SetSampleTime(10); // PID calculation gap time 10 ms
  myPID.SetOutputLimits(-255, 255); // set PID range matching L298N max value

  delay(1000); // wait MPU6050 stable
  move(); // start moving
}


void loop() {
  // Update MPU6050 sensor readings
  mpu.update();

  // Get current angle around Z axis (yaw)
  // MPU6050_light library provides integrated angle directly
  Input = mpu.getAngleZ();

  // The PID will try to make Input (current angle) equal to Direction (0)
  myPID.Compute();

  // Apply the PID correction
  // If the car turns left (negative angle), Output will be negative
  // speedL = baseSpeed - (-Output) = baseSpeed + Output (FASTER)
  // speedR = baseSpeed + (-Output) = baseSpeed - Output (SLOWER)
  // This corrects the left turn by speeding up the left wheel
  int speedL = baseSpeed - Output;
  int speedR = baseSpeed + Output;

  move(speedL, speedR);

  // Serial printing for debugging
  Serial.print("Angle: "); Serial.print(Input);
  Serial.print(" | Output: "); Serial.print(Output);
  Serial.print(" | SpeedL: "); Serial.print(speedL);
  Serial.print(" | SpeedR: "); Serial.println(speedR);

  // No delay() here, the loop should run as fast as possible
  // The PID sample time will handle the timing
}