// WiFi credentials
const char* WIFI_SSID = "***";     //replace *** with your wifi ssid
const char* WIFI_PASSWORD = "***"; //replace *** with your wifi password
#include "SoftwareSerial.h"
#define SOFT_RX 4    // Softserial RX port
#define SOFT_TX 5    //Softserial TX port
SoftwareSerial Serial1(SOFT_RX, SOFT_TX); // RX, TX (D4, D5)
//Define L298N Dual H-Bridge Motor Controller Pins
#define RightDirectPin1  12    //Right Motor direction pin 1 to MODEL-X IN1 grey
#define RightDirectPin2  11    //Right Motor direction pin 1 to MODEL-X IN2 yellow
#define speedPinL 6    //Left PWM pin connect MODEL-X ENB brown
#define LeftDirectPin1  7    //Left Motor direction pin 1 to MODEL-X IN3 green
#define LeftDirectPin2  8   //Left Motor direction pin 1 to MODEL-X IN4 white
#define speedPinR 9    // RIGHT PWM pin connect MODEL-X ENA blue
#define FAST_SPEED 180
#define MID_SPEED 130
int track_speed = 100 ;    //tracking speed
#define SPEED   120  //avoidance motor speed
#define SPEED_LEFT  255
#define SPEED_RIGHT  255
#define BACK_SPEED  200     //back speed
#define TURN_SPEED  200     //back speed

enum DS
{
  MANUAL_DRIVE,
  AUTO_DRIVE_LF, //line follow
  AUTO_DRIVE_UO  //ultrasonic obstruction
}Drive_Status=MANUAL_DRIVE;

enum DN
{ 
  GO_ADVANCE, 
  GO_LEFT, 
  GO_RIGHT,
  GO_BACK,
  STOP_STOP,
  DEF
}Drive_Num=DEF;
String WorkMode="?";
void go_Advance(void)  //Forward
{
  digitalWrite(RightDirectPin1, HIGH);
  digitalWrite(RightDirectPin2,LOW);
  digitalWrite(LeftDirectPin1,HIGH);
  digitalWrite(LeftDirectPin2,LOW);
  set_Motorspeed(SPEED,SPEED);
}
void go_Left()  //Turn left
{
  digitalWrite(RightDirectPin1, HIGH);
  digitalWrite(RightDirectPin2,LOW);
  digitalWrite(LeftDirectPin1,LOW);
  digitalWrite(LeftDirectPin2,HIGH);
  set_Motorspeed(0,SPEED_RIGHT);
}
void go_Right()  //Turn right
{
  digitalWrite(RightDirectPin1, LOW);
  digitalWrite(RightDirectPin2,HIGH);
  digitalWrite(LeftDirectPin1,HIGH);
  digitalWrite(LeftDirectPin2,LOW);
  set_Motorspeed(SPEED_LEFT,0);
}
void go_Back()  //Reverse
{
  digitalWrite(RightDirectPin1, LOW);
  digitalWrite(RightDirectPin2,HIGH);
  digitalWrite(LeftDirectPin1,LOW);
  digitalWrite(LeftDirectPin2,HIGH);
  set_Motorspeed(BACK_SPEED,BACK_SPEED);
}
void stop_Stop()    //Stop
{
  digitalWrite(RightDirectPin1, LOW);
  digitalWrite(RightDirectPin2,LOW);
  digitalWrite(LeftDirectPin1,LOW);
  digitalWrite(LeftDirectPin2,LOW);
  set_Motorspeed(0,0);
}

void set_Motorspeed(int SPEED_L,int SPEED_R)
{
  analogWrite(speedPinL,SPEED_L); 
  analogWrite(speedPinR,SPEED_R);   
}
void do_Drive_Tick()
{

  if(Drive_Status == MANUAL_DRIVE)
  {
    switch (Drive_Num) 
    {
      case GO_ADVANCE:
          go_Advance();
          Serial.println("go ahead");
        //  delay(AHEAD_TIME); 
          break;
      case GO_LEFT: 
          go_Left();
        //  delay(LEFT_TURN_TIME); 
       Serial.println("TURN left");
          break;
      case GO_RIGHT:  
          go_Right();
        //  delay(LEFT_TURN_TIME); 
         Serial.println("TURN right");
          break;
      case GO_BACK: 
          go_Back();
         // delay(BACK_TIME); 
      Serial.println("GO back");
          break;
      case STOP_STOP: 
          stop_Stop();
        //  JogTime = 0;
           Serial.println("STOP");
          break;
      default:
          break;
    }

  }
  else if(Drive_Status==AUTO_DRIVE_LF)
  {
      //Serial.println("auto track");
      //auto_tracking();
  }
  else if(Drive_Status==AUTO_DRIVE_UO)
  { //Serial.println("OBSTACLE AVOID");
   // auto_avoidance();
  }
}

const int UDP_PORT = 8888;

void setup() {
  pinMode(RightDirectPin1, OUTPUT); 
  pinMode(RightDirectPin2, OUTPUT); 
  pinMode(speedPinL, OUTPUT);  
  pinMode(LeftDirectPin1, OUTPUT);
  pinMode(LeftDirectPin2, OUTPUT); 
  pinMode(speedPinR, OUTPUT); 
  stop_Stop();//stop move
  // Initialize Serial Monitor
  Serial.begin(9600);
  //Serial.println("=== ESP32-C3 WiFi Bridge ===");
  Serial.println("Initializing...");

  // Start communication with ESP32 at default baud rate 115200
  Serial1.begin(115200);
  delay(1000);

  // Step 1: Test AT communication
 // Serial.println("Testing AT connection...");
  sendATCommand("AT", 1000);

  // Step 2: Change baud rate to 9600
 // Serial.println("Changing baud rate to 9600...");
  sendATCommand("AT+UART_CUR=9600,8,1,0,0", 2000);
  Serial1.flush();
  // Switch Arduino side to 9600 baud
  Serial1.end();
  delay(500);
  Serial1.begin(9600);
  delay(500);
  sendATCommand("AT+BLEINIT=0", 2000);

  // Step 3: Test communication at new baud rate
 // Serial.println("Testing new baud rate...");
  sendATCommand("AT", 1000);

  // Step 4: Set WiFi mode to Station
 // Serial.println("Setting WiFi mode to Station...");
  sendATCommand("AT+CWMODE=1", 2000);

  // Step 5: Connect to WiFi
  //Serial.print("Connecting to WiFi: ");
  //Serial.println(WIFI_SSID);
  String connectCmd = "AT+CWJAP=\"" + String(WIFI_SSID) + "\",\"" + String(WIFI_PASSWORD) + "\"";
  sendATCommand(connectCmd, 10000); // WiFi connection may take longer

  // Step 6: Get IP address
  Serial.println("Getting IP address...");
  sendATCommand("AT+CIFSR", 2000);

  // Step 7: Enable multiple connections
  //Serial.println("Enabling multiple connections...");
  sendATCommand("AT+CIPMUX=1", 2000);

  // Step 8: Start UDP server on port 8888
  startUDPServer();

  //Serial.println("=== Setup Complete ===");
 // Serial.println("Listening for UDP messages on port 8888...");
 // Serial.println();
}

void loop() {
  // Check if data is available from ESP32
  if (Serial1.available()) {
    // Read all available characters
    String response = "";
    unsigned long startTime = millis();

    // Collect data for up to 100ms
    while (millis() - startTime < 100) {
      while (Serial1.available()) {
        char c = Serial1.read();
        response += c;
        startTime = millis(); // Reset timer when data arrives
      }
    }

    // Parse UDP messages
    if (response.length() > 0) {
      // Parse all UDP messages (format: +IPD,0,5:ST=46)
      int searchStart = 0;
      while (true) {
        int ipdIndex = response.indexOf("+IPD", searchStart);
        if (ipdIndex < 0) {
          break; // No more messages
        }

        // Find the colon after this +IPD
        int colonIndex = response.indexOf(':', ipdIndex);
        if (colonIndex >= 0) {
          // Extract message after the colon until newline
          String message = "";
          for (int i = colonIndex + 1; i < response.length(); i++) {
            char c = response.charAt(i);
            // Stop at newline or carriage return
            if (c == '\r' || c == '\n') {
              break;
            }
            message += c;
          }

          if (message.length() > 0) {
            Serial.print("MSG: ");
            Serial.println(message);
            switch (message[0]) {  // Serial control instructions
              case 'A':
                Drive_Status = MANUAL_DRIVE;
                Drive_Num = GO_ADVANCE;
                WorkMode = "GO_ADVANCE";
                break;
              case 'L':
                Drive_Status = MANUAL_DRIVE;
                Drive_Num = GO_LEFT;
                WorkMode = "GO_LEFT";
                break;
              case 'R':
                Drive_Status = MANUAL_DRIVE;
                Drive_Num = GO_RIGHT;
                WorkMode = "GO_RIGHT";
                break;
              case 'B':
                Drive_Status = MANUAL_DRIVE;
                Drive_Num = GO_BACK;
                WorkMode = "GO_BACK";
                break;
              case 'E':
                Drive_Status = MANUAL_DRIVE;
                Drive_Num = STOP_STOP;
                WorkMode = "STOP_STOP";
                break;
              case 'O':
                Drive_Status = AUTO_DRIVE_UO;
                Serial.println("go OBSTACLE");
                WorkMode = "OBSTACLE";
                break;
              case 'T':
                Drive_Status = AUTO_DRIVE_LF;
                WorkMode = "line follow";
                break;
              case 'G':
                track_speed = track_speed + 10;
                if (track_speed > 200) track_speed = 200;
                break;
              case 'J':
                track_speed = track_speed - 10;
                if (track_speed < 80) track_speed = 80;
                break;
              default:
                break;
            }  // END OF ACTION SWITCH
          }

          // Move search position past this message
          searchStart = colonIndex + message.length() + 1;
        } else {
          break;
        }
      }

      if (response.indexOf("+IPD") >= 0) {
        Serial.println();
      }

      // Check if UDP connection was closed (happens with empty packets)
      if (response.indexOf("0,CLOSED") >= 0) {
        delay(1000);
        startUDPServer();
      }
    }
  }
  do_Drive_Tick();
  // Small delay to prevent overwhelming the serial buffer
  delay(10);
}

// Function to send AT command and wait for response
void sendATCommand(String command, int timeout) {
  // Clear any existing data in buffer
  while (Serial1.available()) {
    Serial1.read();
  }

  // Send command
  Serial1.println(command);

  // Wait for response
  unsigned long startTime = millis();
  String response = "";

  while (millis() - startTime < timeout) {
    while (Serial1.available()) {
      char c = Serial1.read();
      response += c;
    }

    // Check if we got OK or ERROR
    if (response.indexOf("OK") >= 0 || response.indexOf("ERROR") >= 0) {
      break;
    }
  }

  // Extract and print IP address from CIFSR response
  if (command.indexOf("AT+CIFSR") >= 0) {
    int staipIdx = response.indexOf("+CIFSR:STAIP,\"");
    if (staipIdx >= 0) {
      int startIdx = staipIdx + 14; // Length of "+CIFSR:STAIP,\""
      int endIdx = response.indexOf("\"", startIdx);
      if (endIdx > startIdx) {
        String ipAddress = response.substring(startIdx, endIdx);
        Serial.print("IP Address,\"");
        Serial.print(ipAddress);
        Serial.println("\"");
        Serial.println("Your car is ready to go!");
      }
    }
  }

  delay(500);
  
}

// Function to start UDP server
void startUDPServer() {
  // Mode 2: UDP will automatically change remote IP/port when receiving data
  String udpCmd = "AT+CIPSTART=0,\"UDP\",\"0.0.0.0\"," + String(UDP_PORT) + "," + String(UDP_PORT) + ",2";
  sendATCommand(udpCmd, 3000);
}
