/*  ___   ___  ___  _   _  ___   ___   ____ ___  ____  
 * / _ \ /___)/ _ \| | | |/ _ \ / _ \ / ___) _ \|    \ 
 *| |_| |___ | |_| | |_| | |_| | |_| ( (__| |_| | | | |
 * \___/(___/ \___/ \__  |\___/ \___(_)____)___/|_|_|_|
 *                  (____/ 
 *In this course, we will introduce how to use NodeMCU and 
 *UDP protocol with sensors to make a smart light control system.
 * For more details see: https://osoyoo.com/?p=53317
 */

#include <ESP8266WiFi.h>
#include <WiFiUdp.h>

#ifndef STASSID
#define STASSID "***" // replace *** with your wifi SSID
#define STAPSK  "***" // replace *** with your wifi password
#endif

const unsigned int localPort = 8888;  // local port to listen on

// buffers for receiving and sending data
char packetBuffer[UDP_TX_PACKET_MAX_SIZE + 1];  // buffer to hold incoming packet,

WiFiUDP Udp;

// Pins settings
const int sensorPin = A0;
const int lightPin = D1;

bool isLightControlEnabled = true;

void setup() {
  Serial.begin(115200);

  // Connect to Wi-Fi
  WiFi.mode(WIFI_STA);
  WiFi.begin(STASSID, STAPSK);
  while (WiFi.status() != WL_CONNECTED) {
    Serial.print(".");
    delay(500);
  }

  Serial.println();
  Serial.println("Connected! IP address:");
  Serial.println(WiFi.localIP());

  Serial.printf("UDP server on port %d\n", localPort);
  Udp.begin(localPort);

  pinMode(lightPin, OUTPUT);
}

void loop() {
  String msg ;
  int sensorValue = analogRead(sensorPin);
  Serial.print("The sensor Value is:  ");
  Serial.println(sensorValue);
  if (isLightControlEnabled) {
    
    if (sensorValue < 200) {
      digitalWrite(lightPin, HIGH);
      msg = "Dark,the light is on";   
    } else {
      digitalWrite(lightPin, LOW);
      msg = "Bright, the light is off"; 

    }
  }

  int packetSize = Udp.parsePacket();
  if (packetSize) {
    Serial.printf("Received packet of size %d from %s:%d\n    (to %s:%d, free heap = %d B)\n",
                  packetSize,
                  Udp.remoteIP().toString().c_str(), Udp.remotePort(),
                  Udp.destinationIP().toString().c_str(), Udp.localPort(),
                  ESP.getFreeHeap());

    int n = Udp.read(packetBuffer, UDP_TX_PACKET_MAX_SIZE);
    packetBuffer[n] = '\0';
    Serial.println("Contents:");
    Serial.println(packetBuffer);

    if (packetBuffer[0] == 'F') {
      isLightControlEnabled = true;
    } else if (packetBuffer[0] == 'G') {
      isLightControlEnabled = false;
      digitalWrite(lightPin, HIGH);
      msg = "Turn on the light"; 
    } else if (packetBuffer[0] == 'H') {
      isLightControlEnabled = false;
      digitalWrite(lightPin, LOW);
      msg = "Turn off the light";
    }
  }
        msg += "\n";
        Serial.println(msg);
        delay(1000);      
        IPAddress phoneIP = Udp.remoteIP();
        Udp.beginPacket(phoneIP, 8888);
        // Send light sensor value back to the UDP client app
        Udp.write(msg.c_str());
        Udp.endPacket();  
}
